<?php
require_once('utility.php');
function update_liteserver_configuration($argv) {
	global $DTASCFG_XML_FILE, $BACKEND;

	$xml = simplexml_load_file($DTASCFG_XML_FILE);

	$number_of_sandboxes				= (count($argv) > 0 ? $argv[0] : chop($xml->sandbox->number));
	$config_xpath						= (count($argv) > 1 ? $argv[1] : "");
    $cluster_xml						= ($config_xpath != "" ? $xml->$config_xpath : $xml);
    
	$esxi_ip							= chop($cluster_xml->esxi->ip);
	$esxi_username						= chop($cluster_xml->esxi->username);
	$esxi_password						= $cluster_xml->esxi->password;
	$sandbox_controller_admin_username	= chop($xml->sandbox_controller->admin_username);
	$sandbox_controller_admin_password	= $xml->sandbox_controller->admin_password;	
    $sandbox_controller_prefix			= chop($cluster_xml->sandbox_controller->prefix);
	$sandbox_controller_vmpath			= chop($cluster_xml->sandbox_controller->image_path);
	$sandcastle_status_folder			= chop($xml->folder->sandcastle_status);
	$dtas_dir							= chop($xml->cli->dtas_dir);	
	$ip_usage_path                      = dirname(__FILE__) . "/../IPUsage" ;
    $controller_vix_vmpath = get_vm_vixpath($esxi_ip, $esxi_username, $esxi_password, $sandbox_controller_prefix);
    
	debug_print("start_vm_and_wait($sandbox_controller_vmpath)");
	start_vm_and_wait($esxi_ip, $esxi_username, $esxi_password, $sandbox_controller_vmpath);
    
	unset($result_array);
	debug_print("$BACKEND stop_liteserver \"$config_xpath\"");
	exec("$BACKEND stop_liteserver \"$config_xpath\" 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

	// Escape these variables here since they will be used in command line directly
	$esxi_username = escapeshellarg($esxi_username);
	$esxi_password = escapeshellarg($esxi_password);
	$sandbox_controller_admin_username = escapeshellarg($sandbox_controller_admin_username);
	$sandbox_controller_admin_password = escapeshellarg($sandbox_controller_admin_password);
	
	unset($result_array);
	exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" /sbin/service revertd stop 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

	debug_print("create_revertd_conf(" . dirname(__FILE__) . "/../revertd.conf $config_xpath");
	create_revertd_conf(dirname(__FILE__) . "/../revertd.conf", $config_xpath);

	unset($result_array);
	exec("$BACKEND copy_file_from_server_to_vm_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" " . dirname(__FILE__) . "/../revertd.conf $dtas_dir/SandboxController/bin/revertd/revertd.conf 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);
	
	debug_print( "launch \"revertd\" ..." ) ;
	unset($result_array);
	exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" /sbin/service revertd start 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

	create_liteserver_ini(dirname(__FILE__) . "/../LiteServer.ini", $ip_usage_path ) ;
		
	unset($result_array);
	exec("$BACKEND copy_file_from_server_to_vm_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" " . dirname(__FILE__) . "/../LiteServer.ini $dtas_dir/sandcastle/server/LiteServer.ini 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

    unset($result_array);
	exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" /bin/rm -rf $sandcastle_status_folder 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);
	
	unset($result_array);
	exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" /bin/mkdir $sandcastle_status_folder 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

	unset($result_array);
	exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" /sbin/service liteserverd start 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);
}

